implementation module StdBitmap


//	Clean Object I/O library, version 1.0.1.
//	Interface functions for drawing bitmaps.


import	StdArray, StdBool, StdChar, StdFile, StdInt, StdClass
import	ospicture, intrface
import	StdMaybe, StdPicture


::	Bitmap
	=	{	bitmapSize		:: !Size		// The size of the bitmap
		,	bitmapContents	:: !{#Char}		// The bitmap information
		}

getBitmapSize :: !Bitmap -> Size
getBitmapSize { bitmapSize }
	= bitmapSize

openBitmap :: !{#Char} !*env -> (!Maybe Bitmap,!*env)	| FileSystem env
openBitmap name env
	# (ok,file,env)		= fopen name FReadData env
	| not ok
	= (Nothing,env)
	# (ok,bitmap,file)	= readBitmap file
    # (_,env)			= fclose file env
    | not ok
    = (Nothing,env)
	= (Just bitmap,env)
where
	// readBitmap reads a bitmap from a file. See page 176 of Programming Windows 95 (Charles Petzold)
	readBitmap :: !*File -> (!Bool,!Bitmap,!*File)
	readBitmap file
		# (_, c1,file) = freadc file
		# (ok,c2,file) = freadc file      // read first two bytes
		| not ok || c1<>'B' || c2<>'M'	  // are they "BM"? 
		= (False,noBitmap,file)
		# (_,  fileSize,file)	= freadi file // read file size
		# (_,  _,       file)	= freadi file // skip bfReserved1 & 2
		# (_,  _,       file)	= freadi file // skip bfOffBits
		# (_,  _,       file)	= freadi file // skip biSize
		# (_,  w,       file)	= freadi file // read width
		# (ok1,h,       file)	= freadi file // read height
		# (ok2,         file)	= fseek  file 0 FSeekSet
		| not ok1 || not ok2
		= (False,noBitmap,file)
		# (data,file)			= freads file fileSize
		| size data <> fileSize
		= (False,noBitmap,file)
		// otherwise 
		= (True,{bitmapSize={w=w,h=h},bitmapContents=data},file)
	where
		noBitmap = {bitmapSize=zero,bitmapContents={}}

instance Drawables Bitmap where
	draw :: !Bitmap !*Picture -> *Picture
	draw bitmap picture
		# (origin,pen,pictContext,tb)	= peekPicture picture
		# (pictContext,tb)				= drawbitmap bitmap pen.penPos origin pictContext tb
		= unpeekPicture origin pen pictContext tb
	
	drawAt :: !Point !Bitmap !*Picture -> *Picture
	drawAt pos bitmap picture
		# (origin,pen,pictContext,tb)	= peekPicture picture
		# (pictContext,tb)				= drawbitmap bitmap pos origin pictContext tb
		= unpeekPicture origin pen pictContext tb

drawbitmap :: !Bitmap !Point !Origin !OSPictContext !*OSToolbox -> (!OSPictContext,!*OSToolbox)
drawbitmap {bitmapSize={w,h},bitmapContents} pos=:{x=px,y=py} origin=:{x=ox,y=oy} pictContext tb
	= WinDrawBitmap (px-ox,py-oy) (0,0,w,h) bitmapContents (pictContext,tb)
